//	CDesktopWindow.c

#include "CDialogQuick3.h"
#include "CDialogNewDisk.h"
#include "CDialogGetInfo.h"
#include "FSUtils.h"
#include "CDisk.h"
#include "CDesktop.h"
#include "ADFS_Commands.h"
#include "ADFS_Menus.h"
#include "IC_FileIO.h"
#include "ADFS_O_Callbacks.h"
#include "ADFS_Prefs.h"

#ifdef __ROSE__
	#include "CRoseServers.h"
#endif

#include "CDesktopWindow.h"

#define	kDesktopWindowID		129
OSErr ProcessItem(FSSpecPtr myFSSPtr);

CDesktopWindow		*MakeNewDesktopWindow(O_TopicRef *topicRef)
{
	CDesktopWindow	*window = new CDesktopWindow;
	
	if (window) {
		if (!window->IDesktopWindow(topicRef)) {
			window->Dispose();
			window = NULL;
		}
	}

	return window;
}

Boolean		CDesktopWindow::IDesktopWindow(O_TopicRef *topicRef)
{
	Boolean			success = TRUE;
	Rect			windR = (**gPrefsH).windowPrefs[kDTWindIndex].windR;
	
	i_deselectB = TRUE;
	success = _inherited::IFinderWindow(ADFS_Window_DESKTOP, kDesktopWindowID, topicRef);
	SetWindowRect(&windR);

	return success;
}

void	CDesktopWindow::Dispose(void)
{
	CEntryArray		*selectionP;
	
	Prepare();
	selectionP = GetAllDisks();

	HideGetInfo();

	(void)selectionP->Iterate(TA_Iterate_DISPOSE, NULL);
	selectionP->Dispose();
	
	UnPrepare();
	
	_inherited::Dispose();
}


void	CDesktopWindow::Idle(void)
{
	#ifdef __ROSE__
		gRoseServers->Idle();
	#endif
	
	_inherited::Idle();
}

void	CDesktopWindow::Move(EventRecord *event)
{
	_inherited::Move(event);
	(**gPrefsH).windowPrefs[kDTWindIndex].windR = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

void	CDesktopWindow::Size(EventRecord *event)
{
	_inherited::Size(event);
	(**gPrefsH).windowPrefs[kDTWindIndex].windR = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

OSErr	CDesktopWindow::CanAcceptFlavor(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	FlavorType		flavorType, 
	Boolean			*goodFlavorB
) {
	OSErr		err = noErr;
	
	if (flavorType == flavorTypeHFS) {
		*goodFlavorB = TRUE;
	} else {
		err = _inherited::CanAcceptFlavor(theDrag, itemRef, flavorType, goodFlavorB);
	}
	
	return err;
}

OSErr		CDesktopWindow::CanAcceptDrag(DragReference theDrag)
{
	return _inherited::CanAcceptDrag(theDrag);
}

OSErr		CDesktopWindow::DragReceiveFlavor(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	FlavorType		flavorType, 
	void			*data
) {
	OSErr			err			= noErr;
	Boolean			diskImageB	= FALSE;
	
	//	what about promise?
	if (flavorType == flavorTypeHFS) {
		
		if (!i_dragHitTopic) {
			HFSFlavor		hfsFlavor;
			
			diskImageB = TRUE;
			err = HFSFlavorDataFromDrag(theDrag, itemRef, &hfsFlavor);
			if (!err) err = ProcessItem(&hfsFlavor.fileSpec);
		}
	}
	
	if (!err && !diskImageB) {
		err = _inherited::DragReceiveFlavor(theDrag, itemRef, flavorType, data);
	}

	return err;
}

CEntryArray		*CDesktopWindow::GetAllDisks(void)
{
	ADFS_O_CBData_GET_SEL	getSel;
	
	getSel.arrayP				= GetNewEntryArray();
	getSel.not_if_ancestor_selB	= FALSE;

	if (getSel.arrayP) {
		O_CTopic		*cTopicP = GetFirstTopic();
		CEntry			*cEntryP = NULL;
		
		if (cTopicP) cEntryP = GetTopicEntry(cTopicP);
		
		if (cEntryP) {
			cEntryP->ApplyToItems(
				O_Iterate_ALL, 
				ADFS_O_CB_PANE_ARRAY_GET_DISKS, 
				&getSel);
		}
	}
	
	return getSel.arrayP;
}

void		CDesktopWindow::UnMountDrive(short driveNumS)
{
	CEntryArray		*selectionP;
	
	Prepare();

	selectionP = GetAllDisks();
	
	if (selectionP) {
		(void)selectionP->Iterate(TA_Iterate_UNMOUNT_DRIVE, &driveNumS);
		selectionP->Dispose();
	}
	
	UnPrepare();
}

void		CDesktopWindow::UpdateMenus(void)
{
	CDisk	*diskP = IsDiskSelected(NULL);
	
	if (diskP) diskP->UpdateMenus();
	
	#ifdef __ROSE__
		EnableCommand(cmdGen_Close);
	#endif
	
	_inherited::UpdateMenus();
}

void	CDesktopWindow::DoKeyDown(EventRecord *event)
{
	if (i_renameTE) {
		_inherited::DoKeyDown(event);
	} else {
		char		ch			= VirtualASCII(event);
		Boolean		handledB	= FALSE;
		
		if (ch == DELETE_KEY) {
			handledB = DoCommand(cmdPutAway);
		}

		if (!handledB) {
			_inherited::DoKeyDown(event);
		}
	}
}

Boolean		CDesktopWindow::DoCommand(long command)
{
	CDisk		*cDisk = NULL;
	Boolean		handled = FALSE;

	if (!handled) {

		switch (command) {
		
			case cmdPutAway: {
				cDisk = IsDiskSelected(NULL);
				
				while (cDisk) {
					handled = cDisk->DoCommand(command);
					cDisk = IsDiskSelected(NULL);
				}
				break;
			}
			
			case cmdZeroUnused:
				if (Quick3Button(
					"Zero Unused", 
					"Are you sure you want to permanantly erase the data on "
					"all selected disks?  This action is *not* undoable.  You "
					"will no longer be able to undelete any files.", 
					"Erase",	Dlog_Action_NONE, 
					NULL, 		Dlog_Action_NONE, 
					"Cancel",	Dlog_Action_DEFAULT_CANCEL
				) == kDlog_3Button_ItemID_BUTTON_3) {
					break;
				}
				//	no break!
			
			case cmdShowDeleteFiles:
			case cmdMapDisk: {
				CEntryArray		*selectionP;

				selectionP = GetAllDisks();
				
				if (selectionP) {
					(void)selectionP->Iterate(TA_Iterate_DO_COMMAND, &command);
					selectionP->Dispose();
				}
				break;
			}
			
//			case cmdGen_Close:
			case cmdCloseWindow: {
				#ifdef __ROSE__
					gRoseServers->ShowHide(FALSE);
					handled = TRUE;
				#endif
				break;
			}

			default: {
				cDisk = IsDiskSelected(NULL);
				
				if (cDisk) {
					handled = cDisk->DoCommand(command);
				}
				break;
			}
		}
	}
	
	if (!handled) {
		handled = _inherited::DoCommand(command);
	}

	return handled;
}

